<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';

requireAdmin();

$pageTitle = 'پنل ادمین';

// Get statistics
$conn = getDBConnection();

$totalUsers = $conn->query("SELECT COUNT(*) as count FROM users WHERE is_admin = 0")->fetch_assoc()['count'];
$totalOrders = $conn->query("SELECT COUNT(*) as count FROM orders")->fetch_assoc()['count'];
$paidOrders = $conn->query("SELECT COUNT(*) as count FROM orders WHERE status = 'paid'")->fetch_assoc()['count'];
$pendingOrders = $conn->query("SELECT COUNT(*) as count FROM orders WHERE status = 'pending'")->fetch_assoc()['count'];

$totalRevenue = $conn->query("SELECT SUM(price_irr) as total FROM orders WHERE status = 'paid'")->fetch_assoc()['total'] ?? 0;

$conn->close();

// Get recent orders
$recentOrders = getAllOrders(10);

include __DIR__ . '/../includes/header.php';
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700;800&display=swap');

body, h1, h2, h3, h4, h5, h6, p, span, div, a, button, input, textarea, select, label, td, th {
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
}

.fas, .far, .fab, .fa {
    font-family: "Font Awesome 6 Free", "Font Awesome 6 Brands" !important;
}

.admin-container {
    display: flex;
    min-height: calc(100vh - 100px);
    gap: 0;
}

.admin-sidebar {
    width: 250px;
    background: white;
    box-shadow: 2px 0 10px rgba(0,0,0,0.1);
}

.sidebar-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 20px;
    text-align: center;
}

.sidebar-header i {
    font-size: 32px;
    margin-bottom: 10px;
}

.sidebar-header h3 {
    margin: 0;
    font-size: 18px;
}

.sidebar-menu {
    padding: 20px 0;
}

.sidebar-menu a {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 15px 20px;
    color: #666;
    text-decoration: none;
    transition: all 0.3s;
}

.sidebar-menu a:hover {
    background: #f5f5f5;
    color: #667eea;
}

.sidebar-menu a.active {
    background: #667eea;
    color: white;
    border-right: 4px solid #764ba2;
}

.sidebar-menu a i {
    width: 20px;
}

.admin-content {
    flex: 1;
    padding: 30px;
    background: #f5f7fa;
}

.page-header {
    margin-bottom: 30px;
}

.page-header h1 {
    color: #333;
    font-size: 28px;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 30px;
}

.stat-card {
    background: white;
    border-radius: 12px;
    padding: 25px;
    display: flex;
    align-items: center;
    gap: 20px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.stat-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 28px;
    color: white;
}

.stat-icon.blue {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.stat-icon.green {
    background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
}

.stat-icon.orange {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
}

.stat-icon.purple {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
}

.stat-info h3 {
    font-size: 32px;
    color: #333;
    margin: 0 0 5px 0;
}

.stat-info p {
    color: #999;
    margin: 0;
    font-size: 14px;
}

.section {
    background: white;
    border-radius: 12px;
    padding: 25px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.section h2 {
    color: #333;
    margin-bottom: 20px;
    font-size: 20px;
}

.table-responsive {
    overflow-x: auto;
}

.data-table {
    width: 100%;
    border-collapse: collapse;
}

.data-table thead {
    background: #f8f9fa;
}

.data-table th {
    padding: 12px;
    text-align: right;
    font-weight: 600;
    color: #666;
    border-bottom: 2px solid #e0e0e0;
}

.data-table td {
    padding: 12px;
    text-align: right;
    border-bottom: 1px solid #f0f0f0;
}

.badge {
    padding: 5px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.badge-success {
    background: #d4edda;
    color: #155724;
}

.badge-warning {
    background: #fff3cd;
    color: #856404;
}

.badge-error {
    background: #f8d7da;
    color: #721c24;
}

.text-center {
    text-align: center;
    margin-top: 20px;
}

.btn {
    display: inline-block;
    padding: 10px 20px;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
}

@media (max-width: 768px) {
    .admin-container {
        flex-direction: column;
    }
    
    .admin-sidebar {
        width: 100%;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<div class="admin-container">
    <div class="admin-sidebar">
        <div class="sidebar-header">
            <i class="fas fa-shield-alt"></i>
            <h3>پنل مدیریت</h3>
        </div>
        <nav class="sidebar-menu">
            <a href="/admin/" class="active">
                <i class="fas fa-home"></i>
                داشبورد
            </a>
            <a href="/admin/users.php">
                <i class="fas fa-users"></i>
                کاربران
            </a>
            <a href="/admin/orders.php">
                <i class="fas fa-shopping-cart"></i>
                سفارش‌ها
            </a>
            <a href="/admin/esims.php">
                <i class="fas fa-sim-card"></i>
                eSIM ها
            </a>
            <a href="/admin/settings.php">
                <i class="fas fa-cog"></i>
                تنظیمات
            </a>
            <a href="/">
                <i class="fas fa-arrow-left"></i>
                بازگشت به سایت
            </a>
        </nav>
    </div>

    <div class="admin-content">
        <div class="page-header">
            <h1>📊 داشبورد مدیریت</h1>
        </div>

        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon blue">
                    <i class="fas fa-users"></i>
                </div>
                <div class="stat-info">
                    <h3><?php echo $totalUsers; ?></h3>
                    <p>کاربران</p>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon green">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="stat-info">
                    <h3><?php echo $paidOrders; ?></h3>
                    <p>سفارش‌های موفق</p>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon orange">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="stat-info">
                    <h3><?php echo $pendingOrders; ?></h3>
                    <p>در انتظار پرداخت</p>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon purple">
                    <i class="fas fa-money-bill-wave"></i>
                </div>
                <div class="stat-info">
                    <h3><?php echo formatPrice($totalRevenue); ?></h3>
                    <p>درآمد کل (تومان)</p>
                </div>
            </div>
        </div>

        <div class="section">
            <h2>📋 آخرین سفارش‌ها</h2>
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>شماره</th>
                            <th>کاربر</th>
                            <th>بسته</th>
                            <th>مبلغ</th>
                            <th>وضعیت</th>
                            <th>تاریخ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($recentOrders)): ?>
                            <tr>
                                <td colspan="6" style="text-align: center; padding: 30px; color: #999;">
                                    هنوز سفارشی ثبت نشده است
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($recentOrders as $order): ?>
                            <tr>
                                <td>#<?php echo $order['id']; ?></td>
                                <td><?php echo htmlspecialchars($order['mobile']); ?></td>
                                <td><?php echo htmlspecialchars($order['package_name']); ?></td>
                                <td><?php echo formatPrice($order['price_irr']); ?> تومان</td>
                                <td>
                                    <?php if ($order['status'] == 'paid'): ?>
                                        <span class="badge badge-success">✓ پرداخت شده</span>
                                    <?php elseif ($order['status'] == 'pending'): ?>
                                        <span class="badge badge-warning">⏳ در انتظار</span>
                                    <?php else: ?>
                                        <span class="badge badge-error">✗ ناموفق</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo date('Y/m/d H:i', strtotime($order['created_at'])); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php if (!empty($recentOrders)): ?>
            <div class="text-center">
                <a href="/admin/orders.php" class="btn btn-primary">
                    مشاهده همه سفارش‌ها
                    <i class="fas fa-arrow-left"></i>
                </a>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>

